<?php
// Simple email notification endpoint for RASTY.
// Expects JSON payload via POST with keys: to, subject, text.
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
$to      = $data['to'] ?? '';
$subject = $data['subject'] ?? 'RASTY Notification';
$text    = $data['text'] ?? '';

if ($to && filter_var($to, FILTER_VALIDATE_EMAIL)) {
    // Compose minimal headers for the mail function
    $host = $_SERVER['SERVER_NAME'] ?? 'localhost';
    $from = "no-reply@{$host}";
    $headers = "From: {$from}\r\n";
    $headers .= "Reply-To: {$from}\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion();
    $sent = mail($to, $subject, $text, $headers);
    echo json_encode(['sent' => $sent]);
} else {
    echo json_encode(['sent' => false, 'error' => 'invalid email']);
}
?>